/*
 * Decompiled with CFR 0.152.
 */
package net.adventurez.entity.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.adventurez.entity.TheEyeEntity;
import net.adventurez.entity.model.TheEyeModel;
import net.adventurez.init.RenderInit;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix3f;
import org.joml.Matrix4f;

@Environment(value=EnvType.CLIENT)
public class TheEyeRenderer
extends MobRenderer<TheEyeEntity, TheEyeModel<TheEyeEntity>> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("adventurez:textures/entity/the_eye.png");
    private static final ResourceLocation EXPLOSION_BEAM_TEXTURE = new ResourceLocation("adventurez:textures/entity/eye_beam.png");
    private static final RenderType LAYER = RenderType.m_110458_((ResourceLocation)EXPLOSION_BEAM_TEXTURE);

    public TheEyeRenderer(EntityRendererProvider.Context context) {
        super(context, new TheEyeModel(context.m_174023_(RenderInit.THE_EYE_LAYER)), 1.0f);
    }

    public void scale(TheEyeEntity eye, PoseStack matrixStack, float f) {
        matrixStack.m_85841_(4.0f, 4.0f, 4.0f);
    }

    public ResourceLocation getTexture(TheEyeEntity eye) {
        return TEXTURE;
    }

    public boolean shouldRender(TheEyeEntity theEyeEntity, Frustum frustum, double d, double e, double f) {
        LivingEntity livingEntity;
        if (super.m_5523_((Mob)theEyeEntity, frustum, d, e, f)) {
            return true;
        }
        if (theEyeEntity.hasBeamTarget() && (livingEntity = theEyeEntity.getBeamTarget()) != null) {
            Vec3 vec3d = this.fromLerpedPosition(livingEntity, (double)livingEntity.m_20206_() * 0.5, 1.0f);
            Vec3 vec3d2 = this.fromLerpedPosition((LivingEntity)theEyeEntity, theEyeEntity.m_20192_(), 1.0f);
            return frustum.m_113029_(new AABB(vec3d2.f_82479_, vec3d2.f_82480_, vec3d2.f_82481_, vec3d.f_82479_, vec3d.f_82480_, vec3d.f_82481_));
        }
        return false;
    }

    private Vec3 fromLerpedPosition(LivingEntity entity, double yOffset, float delta) {
        double d = Mth.m_14139_((double)delta, (double)entity.f_19790_, (double)entity.m_20185_());
        double e = Mth.m_14139_((double)delta, (double)entity.f_19791_, (double)entity.m_20186_()) + yOffset;
        double f = Mth.m_14139_((double)delta, (double)entity.f_19792_, (double)entity.m_20189_());
        return new Vec3(d, e, f);
    }

    public void render(TheEyeEntity theEyeEntity, float f, float g, PoseStack matrixStack, MultiBufferSource vertexConsumerProvider, int i) {
        super.m_7392_((Mob)theEyeEntity, f, g, matrixStack, vertexConsumerProvider, i);
        LivingEntity livingEntity = theEyeEntity.getBeamTarget();
        if (livingEntity != null && theEyeEntity.m_6084_()) {
            float h = 5.0f;
            float j = (float)theEyeEntity.m_9236_().m_46467_() + g;
            float k = j * 0.5f % 1.0f;
            float l = theEyeEntity.m_20192_();
            matrixStack.m_85836_();
            matrixStack.m_85837_(0.0, (double)l, 0.0);
            Vec3 vec3d = this.fromLerpedPosition(livingEntity, (double)livingEntity.m_20206_() * 0.5, g);
            Vec3 vec3d2 = this.fromLerpedPosition((LivingEntity)theEyeEntity, l, g);
            Vec3 vec3d3 = vec3d.m_82546_(vec3d2);
            float m = (float)(vec3d3.m_82553_() + 1.0);
            vec3d3 = vec3d3.m_82541_();
            float n = (float)Math.acos(vec3d3.f_82480_);
            float o = (float)Math.atan2(vec3d3.f_82481_, vec3d3.f_82479_);
            matrixStack.m_252781_(Axis.f_252436_.m_252977_((1.5707964f - o) * 57.295776f));
            matrixStack.m_252781_(Axis.f_252529_.m_252977_(n * 57.295776f));
            float q = j * 0.05f * -1.5f;
            float r = h * h;
            int s = 64 + (int)(r * 191.0f);
            int t = 32 + (int)(r * 191.0f);
            int u = 128 - (int)(r * 64.0f);
            float x = Mth.m_14089_((float)(q + 2.3561945f)) * 0.282f;
            float y = Mth.m_14031_((float)(q + 2.3561945f)) * 0.282f;
            float z = Mth.m_14089_((float)(q + 0.7853982f)) * 0.282f;
            float aa = Mth.m_14031_((float)(q + 0.7853982f)) * 0.282f;
            float ab = Mth.m_14089_((float)(q + 3.926991f)) * 0.282f;
            float ac = Mth.m_14031_((float)(q + 3.926991f)) * 0.282f;
            float ad = Mth.m_14089_((float)(q + 5.4977875f)) * 0.282f;
            float ae = Mth.m_14031_((float)(q + 5.4977875f)) * 0.282f;
            float af = Mth.m_14089_((float)(q + (float)Math.PI)) * 0.2f;
            float ag = Mth.m_14031_((float)(q + (float)Math.PI)) * 0.2f;
            float ah = Mth.m_14089_((float)(q + 0.0f)) * 0.2f;
            float ai = Mth.m_14031_((float)(q + 0.0f)) * 0.2f;
            float aj = Mth.m_14089_((float)(q + 1.5707964f)) * 0.2f;
            float ak = Mth.m_14031_((float)(q + 1.5707964f)) * 0.2f;
            float al = Mth.m_14089_((float)(q + 4.712389f)) * 0.2f;
            float am = Mth.m_14031_((float)(q + 4.712389f)) * 0.2f;
            float aq = -1.0f + k;
            float ar = m * 2.5f + aq;
            VertexConsumer vertexConsumer = vertexConsumerProvider.m_6299_(LAYER);
            PoseStack.Pose entry = matrixStack.m_85850_();
            Matrix4f matrix4f = entry.m_252922_();
            Matrix3f matrix3f = entry.m_252943_();
            TheEyeRenderer.m_252738_(vertexConsumer, matrix4f, matrix3f, af, m, ag, s, t, u, 0.4999f, ar);
            TheEyeRenderer.m_252738_(vertexConsumer, matrix4f, matrix3f, af, 0.0f, ag, s, t, u, 0.4999f, aq);
            TheEyeRenderer.m_252738_(vertexConsumer, matrix4f, matrix3f, ah, 0.0f, ai, s, t, u, 0.0f, aq);
            TheEyeRenderer.m_252738_(vertexConsumer, matrix4f, matrix3f, ah, m, ai, s, t, u, 0.0f, ar);
            TheEyeRenderer.m_252738_(vertexConsumer, matrix4f, matrix3f, aj, m, ak, s, t, u, 0.4999f, ar);
            TheEyeRenderer.m_252738_(vertexConsumer, matrix4f, matrix3f, aj, 0.0f, ak, s, t, u, 0.4999f, aq);
            TheEyeRenderer.m_252738_(vertexConsumer, matrix4f, matrix3f, al, 0.0f, am, s, t, u, 0.0f, aq);
            TheEyeRenderer.m_252738_(vertexConsumer, matrix4f, matrix3f, al, m, am, s, t, u, 0.0f, ar);
            float as = 0.0f;
            if (theEyeEntity.f_19797_ % 2 == 0) {
                as = 0.5f;
            }
            TheEyeRenderer.m_252738_(vertexConsumer, matrix4f, matrix3f, x, m, y, s, t, u, 0.5f, as + 0.5f);
            TheEyeRenderer.m_252738_(vertexConsumer, matrix4f, matrix3f, z, m, aa, s, t, u, 1.0f, as + 0.5f);
            TheEyeRenderer.m_252738_(vertexConsumer, matrix4f, matrix3f, ad, m, ae, s, t, u, 1.0f, as);
            TheEyeRenderer.m_252738_(vertexConsumer, matrix4f, matrix3f, ab, m, ac, s, t, u, 0.5f, as);
            matrixStack.m_85849_();
        }
    }

    private static void m_252738_(VertexConsumer vertexConsumer, Matrix4f matrix4f, Matrix3f matrix3f, float f, float g, float h, int i, int j, int k, float l, float m) {
        vertexConsumer.m_252986_(matrix4f, f, g, h).m_6122_(i, j, k, 255).m_7421_(l, m).m_86008_(OverlayTexture.f_118083_).m_85969_(0xF000F0).m_252939_(matrix3f, 0.0f, 1.0f, 0.0f).m_5752_();
    }
}

